#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.VAL;

#endregion

namespace gov.va.med.vbecs.GUI
{
	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Margaret Jablonski</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>5/6/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary></summary>

	#endregion

	/// <summary>
	/// Class FrmEnterPostTransfusionInfo
	/// </summary>
	public class FrmEnterPostTransfusionInfo : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Minimum volume that may be transfused
		/// Implements BR_69.08
		/// </summary>
		private const int _minTransfusedVolume = 1;

		/// <summary>
		/// Is form loading
		/// </summary>
		private bool _isLoading;

		/// <summary>
		/// Used to avoid calling method twice
		/// </summary>
		private bool _isUpdatingTransfusedVolume;

		/// <summary>
		/// Current working Patient Transfusion object
		/// </summary>
		private BOL.PatientTransfusion _currentPatientTransfusion;

		/// <summary>
		/// Current working Issued Unit object
		/// </summary>
		private Hashtable _currentUnit;

		/// <summary>
		/// Needed for CreateTargetTabs
		/// </summary>
		private bool _removingTabs = false;

		/// <summary>
		/// Arraylist of Patient Transfusion 
		/// </summary>
		private System.Collections.ArrayList _patientTransfusionList;
		
		/// <summary>
		/// Arraylist of Selected Units 
		/// </summary>
		private System.Collections.ArrayList _selectedUnitsList;

		/// <summary>
		/// Arraylist of all Issued and Transfused Units
		/// </summary>
		private System.Collections.ArrayList _allUnits;

		/// <summary>
		/// Arraylist of Issued Units only
		/// </summary>
		private System.Collections.ArrayList _issuedUnitsOnly;

		/// <summary>
		/// User's security level 4 or above to perform some functionality
		/// </summary>
		private bool _hasSupervisorSecurity;

		/// <summary>
		/// Current Unit Remote Storage Indicator
		/// </summary>
		private bool _remoteStorageIndicator;

		/// <summary>
		/// Current Unit Maximum Transfusion Time
		/// </summary>
		private double _maximumTransfusionTime;

		/// <summary>
		/// Current Unit Date Issued
		/// </summary>
		private DateTime _dateIssued;

		/// <summary>
		/// WorkloadProcessID
		/// </summary>
		private Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.TransfuseUnit;

		#endregion

		#region Form Controls
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpBedsideVerification;
		private System.Windows.Forms.TextBox txtUnitID;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblProduct;
		private System.Windows.Forms.GroupBox grpPostTransfusionInfo;
		private System.Windows.Forms.Label lblTransfusionDate;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPatientLocation;
		private System.Windows.Forms.Label lblPatientLocation;
		private System.Windows.Forms.RadioButton rdoQuarter;
		private System.Windows.Forms.RadioButton rdoHalf;
		private System.Windows.Forms.RadioButton rdoThreeQuarter;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updmL;
		private System.Windows.Forms.RadioButton rdoInterrupted;
		private System.Windows.Forms.GroupBox grpInterrupted;
		private System.Windows.Forms.RadioButton rdoCompleted;
		private System.Windows.Forms.GroupBox grpCompleted;
		private System.Windows.Forms.RadioButton rdoNoReaction;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnUpdate;
		private System.Windows.Forms.Panel pnlPatientUnits;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private gov.va.med.vbecs.GUI.controls.PatientDisplayPanel patientDisplayPanel1;
		private System.Windows.Forms.GroupBox grpSelectUnits;
		private System.Windows.Forms.ListView lvUnits;
		private System.Windows.Forms.GroupBox grpSelectedUnit;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel bloodBagLabel1;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader7;
        private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.TabControl tabUnits;
		private System.Windows.Forms.TabPage pageUnit1;
		private System.Windows.Forms.Panel pnlUnit;
		private System.Windows.Forms.Panel pnlPostTransfusionInfo;
		private System.Windows.Forms.CheckBox cbShowTransfusedUnits;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Panel pnlAmountTransfused;
		private System.Windows.Forms.Label lblAmountTransfused;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.GroupBox grpTrnsImage;
		private System.Windows.Forms.Panel pnlPostTransfusionUnit;
		private System.Windows.Forms.RadioButton rdoVolume;
		private System.Windows.Forms.Label lblmL;
		private System.Windows.Forms.GroupBox grpReactionNoted;
		private System.Windows.Forms.TextBox txtVerificationDate;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.GroupBox grpSymptoms;
		private System.Windows.Forms.GroupBox grpComments;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.TextBox txtComments;
		private System.Windows.Forms.Label lblComments;
		private System.Windows.Forms.TextBox txtSymptoms;
		private System.Windows.Forms.RadioButton rdoReactionNoted;
		private System.Windows.Forms.Label lblSymptoms;
		private System.Windows.Forms.DateTimePicker dtpTransfusionEndDate;
		private System.Windows.Forms.DateTimePicker dtpTransfusionStartDate;
		private System.Windows.Forms.TextBox txtTransfusionistID2;
		private System.Windows.Forms.TextBox txtTransfusionistID1;
		private System.Windows.Forms.TextBox txtIssuedBy;
		private System.Windows.Forms.TextBox txtDateIssued;
		private System.Windows.Forms.TextBox txtPatientID;
		private System.Windows.Forms.TextBox txtPatientName;
		private System.Windows.Forms.TextBox txtProductCode;
        private controls.PatientDisplayPanel patientDisplayPanel2;
		private System.ComponentModel.IContainer components = null;
		#endregion

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmEnterPostTransfusionInfo()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC069PostTransfusionInformation;

			this._isLoading = true;
			
			InitializeComponent();
			
			// CR 2553, 2554
			_hasSupervisorSecurity = IsCurrentUserAuthorizedForFunction(Common.FunctionCode.EditPatientTransfusionRecord);

			SetComponentProperties();
		
			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmEnterPostTransfusionInfo));
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancel = new System.Windows.Forms.Button();
            this.pnlPostTransfusionInfo = new System.Windows.Forms.Panel();
            this.pnlPostTransfusionUnit = new System.Windows.Forms.Panel();
            this.groupBox4 = new System.Windows.Forms.GroupBox();
            this.txtIssuedBy = new System.Windows.Forms.TextBox();
            this.label8 = new System.Windows.Forms.Label();
            this.txtDateIssued = new System.Windows.Forms.TextBox();
            this.label7 = new System.Windows.Forms.Label();
            this.grpPostTransfusionInfo = new System.Windows.Forms.GroupBox();
            this.grpCompleted = new System.Windows.Forms.GroupBox();
            this.rdoCompleted = new System.Windows.Forms.RadioButton();
            this.rdoInterrupted = new System.Windows.Forms.RadioButton();
            this.grpInterrupted = new System.Windows.Forms.GroupBox();
            this.pnlAmountTransfused = new System.Windows.Forms.Panel();
            this.lblmL = new System.Windows.Forms.Label();
            this.updmL = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
            this.lblAmountTransfused = new System.Windows.Forms.Label();
            this.rdoQuarter = new System.Windows.Forms.RadioButton();
            this.rdoHalf = new System.Windows.Forms.RadioButton();
            this.rdoThreeQuarter = new System.Windows.Forms.RadioButton();
            this.rdoVolume = new System.Windows.Forms.RadioButton();
            this.cmbPatientLocation = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPatientLocation = new System.Windows.Forms.Label();
            this.dtpTransfusionEndDate = new System.Windows.Forms.DateTimePicker();
            this.lblTransfusionDate = new System.Windows.Forms.Label();
            this.grpReactionNoted = new System.Windows.Forms.GroupBox();
            this.rdoNoReaction = new System.Windows.Forms.RadioButton();
            this.rdoReactionNoted = new System.Windows.Forms.RadioButton();
            this.grpSymptoms = new System.Windows.Forms.GroupBox();
            this.txtSymptoms = new System.Windows.Forms.TextBox();
            this.lblSymptoms = new System.Windows.Forms.Label();
            this.grpComments = new System.Windows.Forms.GroupBox();
            this.txtComments = new System.Windows.Forms.TextBox();
            this.lblComments = new System.Windows.Forms.Label();
            this.btnUpdate = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpBedsideVerification = new System.Windows.Forms.GroupBox();
            this.dtpTransfusionStartDate = new System.Windows.Forms.DateTimePicker();
            this.label6 = new System.Windows.Forms.Label();
            this.groupBox3 = new System.Windows.Forms.GroupBox();
            this.txtVerificationDate = new System.Windows.Forms.TextBox();
            this.txtTransfusionistID2 = new System.Windows.Forms.TextBox();
            this.txtTransfusionistID1 = new System.Windows.Forms.TextBox();
            this.label4 = new System.Windows.Forms.Label();
            this.label3 = new System.Windows.Forms.Label();
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.txtPatientID = new System.Windows.Forms.TextBox();
            this.txtPatientName = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.label2 = new System.Windows.Forms.Label();
            this.groupBox1 = new System.Windows.Forms.GroupBox();
            this.txtProductCode = new System.Windows.Forms.TextBox();
            this.txtUnitID = new System.Windows.Forms.TextBox();
            this.lblUnitID = new System.Windows.Forms.Label();
            this.lblProduct = new System.Windows.Forms.Label();
            this.label5 = new System.Windows.Forms.Label();
            this.grpTrnsImage = new System.Windows.Forms.GroupBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.tabUnits = new System.Windows.Forms.TabControl();
            this.pageUnit1 = new System.Windows.Forms.TabPage();
            this.pnlUnit = new System.Windows.Forms.Panel();
            this.pnlPatientUnits = new System.Windows.Forms.Panel();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            this.grpSelectUnits = new System.Windows.Forms.GroupBox();
            this.cbShowTransfusedUnits = new System.Windows.Forms.CheckBox();
            this.lvUnits = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpSelectedUnit = new System.Windows.Forms.GroupBox();
            this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
            this.bloodBagLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.patientDisplayPanel2 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlPostTransfusionInfo.SuspendLayout();
            this.pnlPostTransfusionUnit.SuspendLayout();
            this.groupBox4.SuspendLayout();
            this.grpPostTransfusionInfo.SuspendLayout();
            this.grpCompleted.SuspendLayout();
            this.grpInterrupted.SuspendLayout();
            this.pnlAmountTransfused.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.updmL)).BeginInit();
            this.grpReactionNoted.SuspendLayout();
            this.grpSymptoms.SuspendLayout();
            this.grpComments.SuspendLayout();
            this.grpBedsideVerification.SuspendLayout();
            this.grpTrnsImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.tabUnits.SuspendLayout();
            this.pnlPatientUnits.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpSelectUnits.SuspendLayout();
            this.grpSelectedUnit.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(722, 30);
            this.vbecsLogo1.TabIndex = 5;
            this.vbecsLogo1.Title = "Post-Transfusion Information";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 501);
            this.lblRequiredField.TabIndex = 6;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(564, 490);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 3;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.btnCancel.Location = new System.Drawing.Point(644, 490);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // pnlPostTransfusionInfo
            // 
            this.pnlPostTransfusionInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPostTransfusionInfo.Controls.Add(this.patientDisplayPanel2);
            this.pnlPostTransfusionInfo.Controls.Add(this.pnlPostTransfusionUnit);
            this.pnlPostTransfusionInfo.Controls.Add(this.grpTrnsImage);
            this.pnlPostTransfusionInfo.Controls.Add(this.tabUnits);
            this.pnlPostTransfusionInfo.Location = new System.Drawing.Point(0, 32);
            this.pnlPostTransfusionInfo.Name = "pnlPostTransfusionInfo";
            this.pnlPostTransfusionInfo.Size = new System.Drawing.Size(718, 452);
            this.pnlPostTransfusionInfo.TabIndex = 2;
            this.pnlPostTransfusionInfo.VisibleChanged += new System.EventHandler(this.PanelChanges);
            // 
            // pnlPostTransfusionUnit
            // 
            this.pnlPostTransfusionUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPostTransfusionUnit.Controls.Add(this.groupBox4);
            this.pnlPostTransfusionUnit.Controls.Add(this.grpPostTransfusionInfo);
            this.pnlPostTransfusionUnit.Controls.Add(this.btnUpdate);
            this.pnlPostTransfusionUnit.Controls.Add(this.grpBedsideVerification);
            this.pnlPostTransfusionUnit.Location = new System.Drawing.Point(52, 66);
            this.pnlPostTransfusionUnit.Name = "pnlPostTransfusionUnit";
            this.pnlPostTransfusionUnit.Size = new System.Drawing.Size(664, 380);
            this.pnlPostTransfusionUnit.TabIndex = 3;
            // 
            // groupBox4
            // 
            this.groupBox4.AccessibleDescription = "issue details";
            this.groupBox4.AccessibleName = "issue details";
            this.groupBox4.Controls.Add(this.txtIssuedBy);
            this.groupBox4.Controls.Add(this.label8);
            this.groupBox4.Controls.Add(this.txtDateIssued);
            this.groupBox4.Controls.Add(this.label7);
            this.groupBox4.Location = new System.Drawing.Point(4, 4);
            this.groupBox4.Name = "groupBox4";
            this.groupBox4.Size = new System.Drawing.Size(306, 72);
            this.groupBox4.TabIndex = 0;
            this.groupBox4.TabStop = false;
            this.groupBox4.Text = "Issue Details";
            // 
            // txtIssuedBy
            // 
            this.txtIssuedBy.AccessibleDescription = "issued by";
            this.txtIssuedBy.AccessibleName = "issued by";
            this.txtIssuedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtIssuedBy.Location = new System.Drawing.Point(124, 40);
            this.txtIssuedBy.Name = "txtIssuedBy";
            this.txtIssuedBy.ReadOnly = true;
            this.txtIssuedBy.Size = new System.Drawing.Size(162, 20);
            this.txtIssuedBy.TabIndex = 3;
            // 
            // label8
            // 
            this.label8.Location = new System.Drawing.Point(8, 40);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(100, 20);
            this.label8.TabIndex = 2;
            this.label8.Text = "Issued By";
            this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtDateIssued
            // 
            this.txtDateIssued.AccessibleDescription = "date issued";
            this.txtDateIssued.AccessibleName = "date issued";
            this.txtDateIssued.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtDateIssued.Location = new System.Drawing.Point(124, 16);
            this.txtDateIssued.Name = "txtDateIssued";
            this.txtDateIssued.ReadOnly = true;
            this.txtDateIssued.Size = new System.Drawing.Size(162, 20);
            this.txtDateIssued.TabIndex = 1;
            // 
            // label7
            // 
            this.label7.Location = new System.Drawing.Point(8, 16);
            this.label7.Name = "label7";
            this.label7.Size = new System.Drawing.Size(100, 20);
            this.label7.TabIndex = 0;
            this.label7.Text = "Date Issued";
            this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpPostTransfusionInfo
            // 
            this.grpPostTransfusionInfo.AccessibleDescription = "post transfusion information";
            this.grpPostTransfusionInfo.AccessibleName = "post transfusion information";
            this.grpPostTransfusionInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPostTransfusionInfo.Controls.Add(this.grpCompleted);
            this.grpPostTransfusionInfo.Controls.Add(this.cmbPatientLocation);
            this.grpPostTransfusionInfo.Controls.Add(this.lblPatientLocation);
            this.grpPostTransfusionInfo.Controls.Add(this.dtpTransfusionEndDate);
            this.grpPostTransfusionInfo.Controls.Add(this.lblTransfusionDate);
            this.grpPostTransfusionInfo.Controls.Add(this.grpReactionNoted);
            this.grpPostTransfusionInfo.Controls.Add(this.grpComments);
            this.grpPostTransfusionInfo.Location = new System.Drawing.Point(314, 4);
            this.grpPostTransfusionInfo.Name = "grpPostTransfusionInfo";
            this.grpPostTransfusionInfo.Size = new System.Drawing.Size(348, 342);
            this.grpPostTransfusionInfo.TabIndex = 2;
            this.grpPostTransfusionInfo.TabStop = false;
            this.grpPostTransfusionInfo.Text = "Post-Transfusion Information";
            // 
            // grpCompleted
            // 
            this.grpCompleted.AccessibleDescription = "transfusion completed";
            this.grpCompleted.AccessibleName = "transfusion completed";
            this.grpCompleted.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpCompleted.Controls.Add(this.rdoCompleted);
            this.grpCompleted.Controls.Add(this.rdoInterrupted);
            this.grpCompleted.Controls.Add(this.grpInterrupted);
            this.grpCompleted.Location = new System.Drawing.Point(8, 64);
            this.grpCompleted.Name = "grpCompleted";
            this.grpCompleted.Size = new System.Drawing.Size(332, 104);
            this.grpCompleted.TabIndex = 4;
            this.grpCompleted.TabStop = false;
            this.grpCompleted.Text = "Transfusion Completed?*";
            // 
            // rdoCompleted
            // 
            this.rdoCompleted.AccessibleDescription = "transfusion completed";
            this.rdoCompleted.AccessibleName = "transfusion completed";
            this.rdoCompleted.Checked = true;
            this.rdoCompleted.Location = new System.Drawing.Point(12, 16);
            this.rdoCompleted.Name = "rdoCompleted";
            this.rdoCompleted.Size = new System.Drawing.Size(144, 16);
            this.rdoCompleted.TabIndex = 0;
            this.rdoCompleted.TabStop = true;
            this.rdoCompleted.Text = "&Transfusion Completed";
            this.rdoCompleted.CheckedChanged += new System.EventHandler(this.rdoCompleted_CheckedChanged);
            // 
            // rdoInterrupted
            // 
            this.rdoInterrupted.AccessibleDescription = "transfusion interrupted";
            this.rdoInterrupted.AccessibleName = "transfusion interrupted";
            this.rdoInterrupted.Location = new System.Drawing.Point(12, 36);
            this.rdoInterrupted.Name = "rdoInterrupted";
            this.rdoInterrupted.Size = new System.Drawing.Size(144, 16);
            this.rdoInterrupted.TabIndex = 1;
            this.rdoInterrupted.Text = "Transfusion &Interrupted";
            this.rdoInterrupted.CheckedChanged += new System.EventHandler(this.rdoInterrupted_CheckedChanged);
            // 
            // grpInterrupted
            // 
            this.grpInterrupted.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpInterrupted.Controls.Add(this.pnlAmountTransfused);
            this.grpInterrupted.Location = new System.Drawing.Point(8, 36);
            this.grpInterrupted.Name = "grpInterrupted";
            this.grpInterrupted.Size = new System.Drawing.Size(318, 60);
            this.grpInterrupted.TabIndex = 2;
            this.grpInterrupted.TabStop = false;
            // 
            // pnlAmountTransfused
            // 
            this.pnlAmountTransfused.AccessibleDescription = "amount transfused";
            this.pnlAmountTransfused.AccessibleName = "amount transfused";
            this.pnlAmountTransfused.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlAmountTransfused.Controls.Add(this.lblmL);
            this.pnlAmountTransfused.Controls.Add(this.updmL);
            this.pnlAmountTransfused.Controls.Add(this.lblAmountTransfused);
            this.pnlAmountTransfused.Controls.Add(this.rdoQuarter);
            this.pnlAmountTransfused.Controls.Add(this.rdoHalf);
            this.pnlAmountTransfused.Controls.Add(this.rdoThreeQuarter);
            this.pnlAmountTransfused.Controls.Add(this.rdoVolume);
            this.pnlAmountTransfused.Location = new System.Drawing.Point(8, 16);
            this.pnlAmountTransfused.Name = "pnlAmountTransfused";
            this.pnlAmountTransfused.Size = new System.Drawing.Size(304, 42);
            this.pnlAmountTransfused.TabIndex = 0;
            // 
            // lblmL
            // 
            this.lblmL.Location = new System.Drawing.Point(236, 20);
            this.lblmL.Name = "lblmL";
            this.lblmL.Size = new System.Drawing.Size(24, 20);
            this.lblmL.TabIndex = 6;
            this.lblmL.Text = "mL";
            this.lblmL.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // updmL
            // 
            this.updmL.AccessibleDescription = "volume milliliters";
            this.updmL.AccessibleName = "volume milliliters";
            this.updmL.Enabled = false;
            this.updmL.Location = new System.Drawing.Point(192, 20);
            this.updmL.Maximum = new decimal(new int[] {
            2000,
            0,
            0,
            0});
            this.updmL.Name = "updmL";
            this.updmL.Size = new System.Drawing.Size(46, 20);
            this.updmL.TabIndex = 5;
            this.updmL.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.updmL.Value = new decimal(new int[] {
            0,
            0,
            0,
            0});
            this.updmL.TextChanged += new System.EventHandler(this.updmL_ValueChanged);
            this.updmL.ValueChanged += new System.EventHandler(this.updmL_ValueChanged);
            this.updmL.Leave += new System.EventHandler(this.updmL_Leave);
            // 
            // lblAmountTransfused
            // 
            this.lblAmountTransfused.Location = new System.Drawing.Point(16, 0);
            this.lblAmountTransfused.Name = "lblAmountTransfused";
            this.lblAmountTransfused.Size = new System.Drawing.Size(108, 20);
            this.lblAmountTransfused.TabIndex = 0;
            this.lblAmountTransfused.Text = "Amount Transfused*";
            this.lblAmountTransfused.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // rdoQuarter
            // 
            this.rdoQuarter.AccessibleDescription = "quarter";
            this.rdoQuarter.AccessibleName = "quarter";
            this.rdoQuarter.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoQuarter.Location = new System.Drawing.Point(132, 0);
            this.rdoQuarter.Name = "rdoQuarter";
            this.rdoQuarter.Size = new System.Drawing.Size(40, 20);
            this.rdoQuarter.TabIndex = 1;
            this.rdoQuarter.TabStop = true;
            this.rdoQuarter.Text = "&1/4";
            this.rdoQuarter.CheckedChanged += new System.EventHandler(this.rdoQuarter_CheckedChanged);
            // 
            // rdoHalf
            // 
            this.rdoHalf.AccessibleDescription = "half";
            this.rdoHalf.AccessibleName = "half";
            this.rdoHalf.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoHalf.Location = new System.Drawing.Point(176, 0);
            this.rdoHalf.Name = "rdoHalf";
            this.rdoHalf.Size = new System.Drawing.Size(40, 20);
            this.rdoHalf.TabIndex = 2;
            this.rdoHalf.Text = "1/&2";
            this.rdoHalf.CheckedChanged += new System.EventHandler(this.rdoHalf_CheckedChanged);
            // 
            // rdoThreeQuarter
            // 
            this.rdoThreeQuarter.AccessibleDescription = "three quarter";
            this.rdoThreeQuarter.AccessibleName = "three quarter";
            this.rdoThreeQuarter.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.rdoThreeQuarter.Location = new System.Drawing.Point(220, 0);
            this.rdoThreeQuarter.Name = "rdoThreeQuarter";
            this.rdoThreeQuarter.Size = new System.Drawing.Size(40, 20);
            this.rdoThreeQuarter.TabIndex = 3;
            this.rdoThreeQuarter.Text = "&3/4";
            this.rdoThreeQuarter.CheckedChanged += new System.EventHandler(this.rdoThreeQuarter_CheckedChanged);
            // 
            // rdoVolume
            // 
            this.rdoVolume.AccessibleDescription = "volume milliliters";
            this.rdoVolume.AccessibleName = "volume milliliters";
            this.rdoVolume.Location = new System.Drawing.Point(132, 20);
            this.rdoVolume.Name = "rdoVolume";
            this.rdoVolume.Size = new System.Drawing.Size(64, 20);
            this.rdoVolume.TabIndex = 4;
            this.rdoVolume.Text = "&Volume";
            this.rdoVolume.CheckedChanged += new System.EventHandler(this.rdoVolume_CheckedChanged);
            // 
            // cmbPatientLocation
            // 
            this.cmbPatientLocation.AccessibleDescription = "patient location at transfusion ";
            this.cmbPatientLocation.AccessibleName = "patient location at transfusion ";
            this.cmbPatientLocation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPatientLocation.Interval = 500;
            this.cmbPatientLocation.Location = new System.Drawing.Point(176, 40);
            this.cmbPatientLocation.Name = "cmbPatientLocation";
            this.cmbPatientLocation.Size = new System.Drawing.Size(158, 22);
            this.cmbPatientLocation.TabIndex = 3;
            this.cmbPatientLocation.SelectedIndexChanged += new System.EventHandler(this.cmbPatientLocation_SelectedIndexChanged);
            // 
            // lblPatientLocation
            // 
            this.lblPatientLocation.Location = new System.Drawing.Point(16, 40);
            this.lblPatientLocation.Name = "lblPatientLocation";
            this.lblPatientLocation.Size = new System.Drawing.Size(168, 20);
            this.lblPatientLocation.TabIndex = 2;
            this.lblPatientLocation.Text = "Patient Location at Transfusion*";
            this.lblPatientLocation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // dtpTransfusionEndDate
            // 
            this.dtpTransfusionEndDate.AccessibleDescription = "transfusion end date";
            this.dtpTransfusionEndDate.AccessibleName = "transfusion end date";
            this.dtpTransfusionEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpTransfusionEndDate.Location = new System.Drawing.Point(176, 16);
            this.dtpTransfusionEndDate.Name = "dtpTransfusionEndDate";
            this.dtpTransfusionEndDate.Size = new System.Drawing.Size(160, 20);
            this.dtpTransfusionEndDate.TabIndex = 1;
            this.dtpTransfusionEndDate.ValueChanged += new System.EventHandler(this.dtpTransfusionEndDate_ValueChanged);
            // 
            // lblTransfusionDate
            // 
            this.lblTransfusionDate.Location = new System.Drawing.Point(16, 16);
            this.lblTransfusionDate.Name = "lblTransfusionDate";
            this.lblTransfusionDate.Size = new System.Drawing.Size(120, 20);
            this.lblTransfusionDate.TabIndex = 0;
            this.lblTransfusionDate.Text = "Transfusion End Date*";
            this.lblTransfusionDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpReactionNoted
            // 
            this.grpReactionNoted.AccessibleDescription = "transfusion reaction noted";
            this.grpReactionNoted.AccessibleName = "transfusion reaction noted";
            this.grpReactionNoted.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpReactionNoted.Controls.Add(this.rdoNoReaction);
            this.grpReactionNoted.Controls.Add(this.rdoReactionNoted);
            this.grpReactionNoted.Controls.Add(this.grpSymptoms);
            this.grpReactionNoted.Location = new System.Drawing.Point(8, 172);
            this.grpReactionNoted.Name = "grpReactionNoted";
            this.grpReactionNoted.Size = new System.Drawing.Size(332, 108);
            this.grpReactionNoted.TabIndex = 5;
            this.grpReactionNoted.TabStop = false;
            this.grpReactionNoted.Text = "Transfusion Reaction Noted?*";
            // 
            // rdoNoReaction
            // 
            this.rdoNoReaction.AccessibleDescription = "no reaction";
            this.rdoNoReaction.AccessibleName = "no reaction";
            this.rdoNoReaction.Location = new System.Drawing.Point(12, 16);
            this.rdoNoReaction.Name = "rdoNoReaction";
            this.rdoNoReaction.Size = new System.Drawing.Size(100, 16);
            this.rdoNoReaction.TabIndex = 0;
            this.rdoNoReaction.TabStop = true;
            this.rdoNoReaction.Text = "&No Reaction";
            this.rdoNoReaction.CheckedChanged += new System.EventHandler(this.rdoNoReaction_CheckedChanged);
            // 
            // rdoReactionNoted
            // 
            this.rdoReactionNoted.AccessibleDescription = "reaction noted";
            this.rdoReactionNoted.AccessibleName = "reaction noted";
            this.rdoReactionNoted.Location = new System.Drawing.Point(12, 36);
            this.rdoReactionNoted.Name = "rdoReactionNoted";
            this.rdoReactionNoted.Size = new System.Drawing.Size(104, 16);
            this.rdoReactionNoted.TabIndex = 1;
            this.rdoReactionNoted.Text = "&Reaction Noted";
            this.rdoReactionNoted.CheckedChanged += new System.EventHandler(this.rdoReactionNoted_CheckedChanged);
            // 
            // grpSymptoms
            // 
            this.grpSymptoms.AccessibleDescription = "symptoms";
            this.grpSymptoms.AccessibleName = "symptoms";
            this.grpSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSymptoms.Controls.Add(this.txtSymptoms);
            this.grpSymptoms.Controls.Add(this.lblSymptoms);
            this.grpSymptoms.Location = new System.Drawing.Point(8, 36);
            this.grpSymptoms.Name = "grpSymptoms";
            this.grpSymptoms.Size = new System.Drawing.Size(318, 64);
            this.grpSymptoms.TabIndex = 2;
            this.grpSymptoms.TabStop = false;
            // 
            // txtSymptoms
            // 
            this.txtSymptoms.AccessibleDescription = "symptoms";
            this.txtSymptoms.AccessibleName = "symptoms";
            this.txtSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSymptoms.Location = new System.Drawing.Point(76, 20);
            this.txtSymptoms.MaxLength = 255;
            this.txtSymptoms.Multiline = true;
            this.txtSymptoms.Name = "txtSymptoms";
            this.txtSymptoms.Size = new System.Drawing.Size(234, 36);
            this.txtSymptoms.TabIndex = 1;
            this.txtSymptoms.TextChanged += new System.EventHandler(this.txtSymptoms_TextChanged);
            // 
            // lblSymptoms
            // 
            this.lblSymptoms.Location = new System.Drawing.Point(20, 16);
            this.lblSymptoms.Name = "lblSymptoms";
            this.lblSymptoms.Size = new System.Drawing.Size(60, 20);
            this.lblSymptoms.TabIndex = 0;
            this.lblSymptoms.Text = "Symptoms";
            this.lblSymptoms.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpComments
            // 
            this.grpComments.AccessibleDescription = "comments";
            this.grpComments.AccessibleName = "comments";
            this.grpComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpComments.Controls.Add(this.txtComments);
            this.grpComments.Controls.Add(this.lblComments);
            this.grpComments.Location = new System.Drawing.Point(8, 280);
            this.grpComments.Name = "grpComments";
            this.grpComments.Size = new System.Drawing.Size(332, 56);
            this.grpComments.TabIndex = 6;
            this.grpComments.TabStop = false;
            // 
            // txtComments
            // 
            this.txtComments.AccessibleDescription = "comments";
            this.txtComments.AccessibleName = "comments";
            this.txtComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtComments.Location = new System.Drawing.Point(84, 12);
            this.txtComments.MaxLength = 255;
            this.txtComments.Multiline = true;
            this.txtComments.Name = "txtComments";
            this.txtComments.Size = new System.Drawing.Size(234, 36);
            this.txtComments.TabIndex = 1;
            this.txtComments.TextChanged += new System.EventHandler(this.txtComments_TextChanged);
            // 
            // lblComments
            // 
            this.lblComments.Location = new System.Drawing.Point(8, 12);
            this.lblComments.Name = "lblComments";
            this.lblComments.Size = new System.Drawing.Size(76, 20);
            this.lblComments.TabIndex = 0;
            this.lblComments.Text = "Comments";
            this.lblComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnUpdate
            // 
            this.btnUpdate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnUpdate.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnUpdate.Image = ((System.Drawing.Image)(resources.GetObject("btnUpdate.Image")));
            this.btnUpdate.Location = new System.Drawing.Point(586, 354);
            this.btnUpdate.Name = "btnUpdate";
            this.btnUpdate.Size = new System.Drawing.Size(75, 23);
            this.btnUpdate.TabIndex = 3;
            this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
            // 
            // grpBedsideVerification
            // 
            this.grpBedsideVerification.AccessibleDescription = "bedside verification";
            this.grpBedsideVerification.AccessibleName = "bedside verification";
            this.grpBedsideVerification.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpBedsideVerification.Controls.Add(this.dtpTransfusionStartDate);
            this.grpBedsideVerification.Controls.Add(this.label6);
            this.grpBedsideVerification.Controls.Add(this.groupBox3);
            this.grpBedsideVerification.Controls.Add(this.txtVerificationDate);
            this.grpBedsideVerification.Controls.Add(this.txtTransfusionistID2);
            this.grpBedsideVerification.Controls.Add(this.txtTransfusionistID1);
            this.grpBedsideVerification.Controls.Add(this.label4);
            this.grpBedsideVerification.Controls.Add(this.label3);
            this.grpBedsideVerification.Controls.Add(this.groupBox2);
            this.grpBedsideVerification.Controls.Add(this.txtPatientID);
            this.grpBedsideVerification.Controls.Add(this.txtPatientName);
            this.grpBedsideVerification.Controls.Add(this.label1);
            this.grpBedsideVerification.Controls.Add(this.label2);
            this.grpBedsideVerification.Controls.Add(this.groupBox1);
            this.grpBedsideVerification.Controls.Add(this.txtProductCode);
            this.grpBedsideVerification.Controls.Add(this.txtUnitID);
            this.grpBedsideVerification.Controls.Add(this.lblUnitID);
            this.grpBedsideVerification.Controls.Add(this.lblProduct);
            this.grpBedsideVerification.Controls.Add(this.label5);
            this.grpBedsideVerification.Location = new System.Drawing.Point(4, 80);
            this.grpBedsideVerification.Name = "grpBedsideVerification";
            this.grpBedsideVerification.Size = new System.Drawing.Size(306, 266);
            this.grpBedsideVerification.TabIndex = 1;
            this.grpBedsideVerification.TabStop = false;
            this.grpBedsideVerification.Text = "Bedside Verification Check";
            // 
            // dtpTransfusionStartDate
            // 
            this.dtpTransfusionStartDate.AccessibleDescription = "transfusion start date";
            this.dtpTransfusionStartDate.AccessibleName = "transfusion start date";
            this.dtpTransfusionStartDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpTransfusionStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpTransfusionStartDate.Location = new System.Drawing.Point(124, 184);
            this.dtpTransfusionStartDate.Name = "dtpTransfusionStartDate";
            this.dtpTransfusionStartDate.Size = new System.Drawing.Size(162, 20);
            this.dtpTransfusionStartDate.TabIndex = 14;
            this.dtpTransfusionStartDate.ValueChanged += new System.EventHandler(this.dtpTransfusionStartDate_ValueChanged);
            // 
            // label6
            // 
            this.label6.Location = new System.Drawing.Point(8, 184);
            this.label6.Name = "label6";
            this.label6.Size = new System.Drawing.Size(124, 20);
            this.label6.TabIndex = 13;
            this.label6.Text = "Transfusion Start Date*";
            this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // groupBox3
            // 
            this.groupBox3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox3.Location = new System.Drawing.Point(8, 172);
            this.groupBox3.Name = "groupBox3";
            this.groupBox3.Size = new System.Drawing.Size(278, 7);
            this.groupBox3.TabIndex = 12;
            this.groupBox3.TabStop = false;
            // 
            // txtVerificationDate
            // 
            this.txtVerificationDate.AccessibleDescription = "Verification Date";
            this.txtVerificationDate.AccessibleName = "Verification Date";
            this.txtVerificationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtVerificationDate.Location = new System.Drawing.Point(124, 20);
            this.txtVerificationDate.Name = "txtVerificationDate";
            this.txtVerificationDate.ReadOnly = true;
            this.txtVerificationDate.Size = new System.Drawing.Size(162, 20);
            this.txtVerificationDate.TabIndex = 1;
            // 
            // txtTransfusionistID2
            // 
            this.txtTransfusionistID2.AccessibleDescription = "transfusion I D number 2";
            this.txtTransfusionistID2.AccessibleName = "transfusion I D number 2";
            this.txtTransfusionistID2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTransfusionistID2.Location = new System.Drawing.Point(124, 232);
            this.txtTransfusionistID2.MaxLength = 30;
            this.txtTransfusionistID2.Name = "txtTransfusionistID2";
            this.txtTransfusionistID2.Size = new System.Drawing.Size(162, 20);
            this.txtTransfusionistID2.TabIndex = 18;
            this.txtTransfusionistID2.TextChanged += new System.EventHandler(this.txtTransfusionistID2_TextChanged);
            // 
            // txtTransfusionistID1
            // 
            this.txtTransfusionistID1.AccessibleDescription = "transfusion I D number 1";
            this.txtTransfusionistID1.AccessibleName = "transfusion I D number 1";
            this.txtTransfusionistID1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTransfusionistID1.Location = new System.Drawing.Point(124, 208);
            this.txtTransfusionistID1.MaxLength = 30;
            this.txtTransfusionistID1.Name = "txtTransfusionistID1";
            this.txtTransfusionistID1.Size = new System.Drawing.Size(162, 20);
            this.txtTransfusionistID1.TabIndex = 16;
            this.txtTransfusionistID1.TextChanged += new System.EventHandler(this.txtTransfusionistID1_TextChanged);
            // 
            // label4
            // 
            this.label4.Location = new System.Drawing.Point(8, 208);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(108, 20);
            this.label4.TabIndex = 15;
            this.label4.Text = "Transfusionist ID #1";
            this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(8, 20);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(100, 20);
            this.label3.TabIndex = 0;
            this.label3.Text = "Verification Date";
            this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // groupBox2
            // 
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.Location = new System.Drawing.Point(8, 40);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(278, 7);
            this.groupBox2.TabIndex = 2;
            this.groupBox2.TabStop = false;
            // 
            // txtPatientID
            // 
            this.txtPatientID.AccessibleDescription = "patient i d";
            this.txtPatientID.AccessibleName = "patient i d";
            this.txtPatientID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPatientID.Location = new System.Drawing.Point(124, 152);
            this.txtPatientID.Name = "txtPatientID";
            this.txtPatientID.ReadOnly = true;
            this.txtPatientID.Size = new System.Drawing.Size(162, 20);
            this.txtPatientID.TabIndex = 11;
            // 
            // txtPatientName
            // 
            this.txtPatientName.AccessibleDescription = "patient name";
            this.txtPatientName.AccessibleName = "patient name";
            this.txtPatientName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPatientName.Location = new System.Drawing.Point(124, 108);
            this.txtPatientName.Multiline = true;
            this.txtPatientName.Name = "txtPatientName";
            this.txtPatientName.ReadOnly = true;
            this.txtPatientName.Size = new System.Drawing.Size(162, 40);
            this.txtPatientName.TabIndex = 9;
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(8, 108);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(80, 20);
            this.label1.TabIndex = 8;
            this.label1.Text = "Patient Name";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // label2
            // 
            this.label2.Location = new System.Drawing.Point(8, 152);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(80, 20);
            this.label2.TabIndex = 10;
            this.label2.Text = "Patient ID";
            this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // groupBox1
            // 
            this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox1.Location = new System.Drawing.Point(8, 96);
            this.groupBox1.Name = "groupBox1";
            this.groupBox1.Size = new System.Drawing.Size(278, 7);
            this.groupBox1.TabIndex = 7;
            this.groupBox1.TabStop = false;
            // 
            // txtProductCode
            // 
            this.txtProductCode.AccessibleDescription = "product code";
            this.txtProductCode.AccessibleName = "product code";
            this.txtProductCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtProductCode.Location = new System.Drawing.Point(124, 76);
            this.txtProductCode.Name = "txtProductCode";
            this.txtProductCode.ReadOnly = true;
            this.txtProductCode.Size = new System.Drawing.Size(162, 20);
            this.txtProductCode.TabIndex = 6;
            // 
            // txtUnitID
            // 
            this.txtUnitID.AccessibleDescription = "unit i d";
            this.txtUnitID.AccessibleName = "unit i d";
            this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtUnitID.Location = new System.Drawing.Point(124, 52);
            this.txtUnitID.Name = "txtUnitID";
            this.txtUnitID.ReadOnly = true;
            this.txtUnitID.Size = new System.Drawing.Size(162, 20);
            this.txtUnitID.TabIndex = 4;
            // 
            // lblUnitID
            // 
            this.lblUnitID.Location = new System.Drawing.Point(8, 52);
            this.lblUnitID.Name = "lblUnitID";
            this.lblUnitID.Size = new System.Drawing.Size(68, 20);
            this.lblUnitID.TabIndex = 3;
            this.lblUnitID.Text = "Unit ID";
            this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblProduct
            // 
            this.lblProduct.Location = new System.Drawing.Point(8, 76);
            this.lblProduct.Name = "lblProduct";
            this.lblProduct.Size = new System.Drawing.Size(80, 20);
            this.lblProduct.TabIndex = 5;
            this.lblProduct.Text = "Product Code";
            this.lblProduct.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // label5
            // 
            this.label5.Location = new System.Drawing.Point(8, 232);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(108, 20);
            this.label5.TabIndex = 17;
            this.label5.Text = "Transfusionist ID #2";
            this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpTrnsImage
            // 
            this.grpTrnsImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpTrnsImage.Controls.Add(this.pictureBox2);
            this.grpTrnsImage.Location = new System.Drawing.Point(4, 40);
            this.grpTrnsImage.Name = "grpTrnsImage";
            this.grpTrnsImage.Size = new System.Drawing.Size(40, 410);
            this.grpTrnsImage.TabIndex = 1;
            this.grpTrnsImage.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 8);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(32, 36);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // tabUnits
            // 
            this.tabUnits.AccessibleDescription = "Units";
            this.tabUnits.AccessibleName = "Units";
            this.tabUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabUnits.Controls.Add(this.pageUnit1);
            this.tabUnits.Location = new System.Drawing.Point(48, 44);
            this.tabUnits.Name = "tabUnits";
            this.tabUnits.SelectedIndex = 0;
            this.tabUnits.Size = new System.Drawing.Size(670, 406);
            this.tabUnits.TabIndex = 2;
            this.tabUnits.SelectedIndexChanged += new System.EventHandler(this.tabUnits_SelectedIndexChanged);
            // 
            // pageUnit1
            // 
            this.pageUnit1.Location = new System.Drawing.Point(4, 23);
            this.pageUnit1.Name = "pageUnit1";
            this.pageUnit1.Size = new System.Drawing.Size(662, 379);
            this.pageUnit1.TabIndex = 0;
            this.pageUnit1.Text = "W123456789012, PLT wash";
            // 
            // pnlUnit
            // 
            this.pnlUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlUnit.Location = new System.Drawing.Point(0, 0);
            this.pnlUnit.Name = "pnlUnit";
            this.pnlUnit.Size = new System.Drawing.Size(634, 378);
            this.pnlUnit.TabIndex = 0;
            // 
            // pnlPatientUnits
            // 
            this.pnlPatientUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPatientUnits.Controls.Add(this.grpImage);
            this.pnlPatientUnits.Controls.Add(this.patientDisplayPanel1);
            this.pnlPatientUnits.Controls.Add(this.grpSelectUnits);
            this.pnlPatientUnits.Controls.Add(this.grpSelectedUnit);
            this.pnlPatientUnits.Location = new System.Drawing.Point(0, 32);
            this.pnlPatientUnits.Name = "pnlPatientUnits";
            this.pnlPatientUnits.Size = new System.Drawing.Size(722, 452);
            this.pnlPatientUnits.TabIndex = 1;
            this.pnlPatientUnits.VisibleChanged += new System.EventHandler(this.PanelChanges);
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 44);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 404);
            this.grpImage.TabIndex = 1;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 32);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(720, 44);
            this.patientDisplayPanel1.TabIndex = 0;
            // 
            // grpSelectUnits
            // 
            this.grpSelectUnits.AccessibleDescription = "Select Units to Enter Post-Transfusion Information";
            this.grpSelectUnits.AccessibleName = "Select Units to Enter Post-Transfusion Information";
            this.grpSelectUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectUnits.Controls.Add(this.cbShowTransfusedUnits);
            this.grpSelectUnits.Controls.Add(this.lvUnits);
            this.grpSelectUnits.Location = new System.Drawing.Point(48, 44);
            this.grpSelectUnits.Name = "grpSelectUnits";
            this.grpSelectUnits.Size = new System.Drawing.Size(386, 404);
            this.grpSelectUnits.TabIndex = 2;
            this.grpSelectUnits.TabStop = false;
            this.grpSelectUnits.Text = "Select Units to Enter Post-Transfusion Information";
            // 
            // cbShowTransfusedUnits
            // 
            this.cbShowTransfusedUnits.AccessibleDescription = "Show Transfused Units";
            this.cbShowTransfusedUnits.AccessibleName = "Show Transfused Units";
            this.cbShowTransfusedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowTransfusedUnits.Enabled = false;
            this.cbShowTransfusedUnits.Location = new System.Drawing.Point(8, 384);
            this.cbShowTransfusedUnits.Name = "cbShowTransfusedUnits";
            this.cbShowTransfusedUnits.Size = new System.Drawing.Size(368, 16);
            this.cbShowTransfusedUnits.TabIndex = 1;
            this.cbShowTransfusedUnits.Text = "Show Transfused Units (those not received by BCE COTS)";
            this.cbShowTransfusedUnits.CheckedChanged += new System.EventHandler(this.cbShowTransfusedUnits_CheckedChanged);
            // 
            // lvUnits
            // 
            this.lvUnits.AccessibleDescription = "Units";
            this.lvUnits.AccessibleName = "Units";
            this.lvUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvUnits.CheckBoxes = true;
            this.lvUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader6,
            this.columnHeader7});
            this.lvUnits.FullRowSelect = true;
            this.lvUnits.Location = new System.Drawing.Point(8, 16);
            this.lvUnits.MultiSelect = false;
            this.lvUnits.Name = "lvUnits";
            this.lvUnits.Size = new System.Drawing.Size(370, 368);
            this.lvUnits.TabIndex = 0;
            this.lvUnits.UseCompatibleStateImageBehavior = false;
            this.lvUnits.View = System.Windows.Forms.View.Details;
            this.lvUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUnits_ItemCheck);
            this.lvUnits.SelectedIndexChanged += new System.EventHandler(this.lvUnits_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 25;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Unit ID";
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Product";
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "ABO/Rh";
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Expires";
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Date Issued";
            this.columnHeader6.Width = 70;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "Transfusion End Date";
            // 
            // grpSelectedUnit
            // 
            this.grpSelectedUnit.AccessibleDescription = "Selected Unit Details";
            this.grpSelectedUnit.AccessibleName = "Selected Unit Details";
            this.grpSelectedUnit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectedUnit.Controls.Add(this.bloodUnitDetailsTab1);
            this.grpSelectedUnit.Controls.Add(this.bloodBagLabel1);
            this.grpSelectedUnit.Location = new System.Drawing.Point(440, 44);
            this.grpSelectedUnit.Name = "grpSelectedUnit";
            this.grpSelectedUnit.Size = new System.Drawing.Size(282, 404);
            this.grpSelectedUnit.TabIndex = 3;
            this.grpSelectedUnit.TabStop = false;
            this.grpSelectedUnit.Text = "Selected Unit Details";
            // 
            // bloodUnitDetailsTab1
            // 
            this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitDetailsTab1.BloodUnit = null;
            this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(8, 224);
            this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
            this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(266, 172);
            this.bloodUnitDetailsTab1.TabIndex = 0;
            // 
            // bloodBagLabel1
            // 
            this.bloodBagLabel1.BackColor = System.Drawing.Color.WhiteSmoke;
            this.bloodBagLabel1.BloodUnit = null;
            this.bloodBagLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodBagLabel1.Location = new System.Drawing.Point(8, 16);
            this.bloodBagLabel1.Name = "bloodBagLabel1";
            this.bloodBagLabel1.Size = new System.Drawing.Size(257, 204);
            this.bloodBagLabel1.TabIndex = 0;
            this.bloodBagLabel1.TabStop = false;
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientSelectTool1.Location = new System.Drawing.Point(4, 32);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.patientSelectTool1.Size = new System.Drawing.Size(718, 452);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            this.patientSelectTool1.VisibleChanged += new System.EventHandler(this.PanelChanges);
            // 
            // patientDisplayPanel2
            // 
            this.patientDisplayPanel2.EnabledBloodAvailButton = false;
            this.patientDisplayPanel2.EnabledMedicationButton = false;
            this.patientDisplayPanel2.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel2.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel2.EnabledSIAndTRButton = false;
            this.patientDisplayPanel2.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel2.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel2.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel2.Name = "patientDisplayPanel2";
            this.patientDisplayPanel2.Patient = null;
            this.patientDisplayPanel2.Size = new System.Drawing.Size(716, 44);
            this.patientDisplayPanel2.TabIndex = 4;
            // 
            // FrmEnterPostTransfusionInfo
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(722, 515);
            this.Controls.Add(this.pnlPostTransfusionInfo);
            this.Controls.Add(this.pnlPatientUnits);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.patientSelectTool1);
            this.hlphelpChm.SetHelpKeyword(this, "Post-Transfusion_Information.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(730, 542);
            this.Name = "FrmEnterPostTransfusionInfo";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Post-Transfusion Information";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmEnterPostTransfusionInfo_KeyDownSpeakMessage);
            this.Load += new System.EventHandler(this.FrmEnterPostTransfusionInfo_Load);
            this.Controls.SetChildIndex(this.patientSelectTool1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.pnlPatientUnits, 0);
            this.Controls.SetChildIndex(this.pnlPostTransfusionInfo, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlPostTransfusionInfo.ResumeLayout(false);
            this.pnlPostTransfusionUnit.ResumeLayout(false);
            this.groupBox4.ResumeLayout(false);
            this.groupBox4.PerformLayout();
            this.grpPostTransfusionInfo.ResumeLayout(false);
            this.grpCompleted.ResumeLayout(false);
            this.grpInterrupted.ResumeLayout(false);
            this.pnlAmountTransfused.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.updmL)).EndInit();
            this.grpReactionNoted.ResumeLayout(false);
            this.grpSymptoms.ResumeLayout(false);
            this.grpSymptoms.PerformLayout();
            this.grpComments.ResumeLayout(false);
            this.grpComments.PerformLayout();
            this.grpBedsideVerification.ResumeLayout(false);
            this.grpBedsideVerification.PerformLayout();
            this.grpTrnsImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.tabUnits.ResumeLayout(false);
            this.pnlPatientUnits.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpSelectUnits.ResumeLayout(false);
            this.grpSelectedUnit.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion
	
		#region Methods

		/// <summary>
		/// CR 2959
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmEnterPostTransfusionInfo());
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			//set custom date and time format
			this.dtpTransfusionStartDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpTransfusionEndDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//Default dates to division current datetime
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpTransfusionEndDate.Value = _currentDate;
			this.dtpTransfusionStartDate.Value = _currentDate;

			//Display Patient Select Tool control first
			this.patientSelectTool1.BringToFront();
			this.patientSelectTool1.Focus();

			//Set Panels visibility property
			this.patientSelectTool1.Visible = true;
			this.pnlPatientUnits.Visible = false;
			this.pnlPostTransfusionInfo.Visible = false;
			this.pnlPostTransfusionUnit.Visible = false;
			this.pnlUnit.Visible = false;

			//Set the tooltips of the controls
			this.ttToolTip.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			
			//
			this._selectedUnitsList = new System.Collections.ArrayList();
			this._patientTransfusionList = new System.Collections.ArrayList();

			if ( _hasSupervisorSecurity )
			{
				// If user has security level 4 or above show Transfused Units check box 
				this.cbShowTransfusedUnits.Enabled = true;
			}
		}

		/// <summary>
		/// Populate select Units to enter post transfusion information list
		/// </summary>
		private void PopulateUnitsListView()
		{
			this.bloodBagLabel1.BloodUnit = null;
			this.bloodUnitDetailsTab1.BloodUnit = null;
			//
			this.lvUnits.Items.Clear();
			//
			// CR 2983: removed code for units from BCE
			//
			if(this.cbShowTransfusedUnits.Checked)
			{
				// Display all units
				this.lvUnits.CheckBoxes = true;
				foreach (Hashtable ht in _allUnits)
				{
					ListViewItem issuedUnitsList = new ListViewItem();
					issuedUnitsList.Tag = ht;
					//
					issuedUnitsList.SubItems.Add(ht[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString() );
					issuedUnitsList.SubItems.Add(string.Concat(ht[Common.VbecsTables.BloodProduct.ProductShortName].ToString(), ", ", BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(ht[Common.VbecsTables.BloodUnit.LabelTypeCode]),ht[Common.VbecsTables.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(ht[Common.VbecsTables.DonationType.DonationTypeCode]),ht[Common.VbecsTables.BloodUnit.UnitDivisionId].ToString())));
					issuedUnitsList.SubItems.Add(ht[Common.DatabaseConstants.ArtificialColumnNames.ABORh].ToString() );
					// CR 2603 Fixed DateTime conversion
					issuedUnitsList.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(ht[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate]));
					issuedUnitsList.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(ht[Common.VbecsTables.IssuedUnit.IssueDateTime]));
					if((DateTime) ht[Common.VbecsTables.PatientTransfusion.TransfusionEndDateTime] != System.DateTime.MinValue)
						issuedUnitsList.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(ht[Common.VbecsTables.PatientTransfusion.TransfusionEndDateTime]));
					//
					this.lvUnits.Items.Add(issuedUnitsList);
				}
			}
			else
			{
				// Only show Issued units
				this.lvUnits.CheckBoxes = true;
				foreach (Hashtable ht in _issuedUnitsOnly)
				{
					ListViewItem issuedUnitsList = new ListViewItem();
					issuedUnitsList.Tag = ht;
					issuedUnitsList.SubItems.Add(ht[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString() );
					issuedUnitsList.SubItems.Add(string.Concat(ht[Common.VbecsTables.BloodProduct.ProductShortName].ToString(), ", ", BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(ht[Common.VbecsTables.BloodUnit.LabelTypeCode]),ht[Common.VbecsTables.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(ht[Common.VbecsTables.DonationType.DonationTypeCode]),ht[Common.VbecsTables.BloodUnit.UnitDivisionId].ToString())));
					issuedUnitsList.SubItems.Add(ht[Common.DatabaseConstants.ArtificialColumnNames.ABORh].ToString() );
					// CR 2603 Fixed DateTime conversion
					issuedUnitsList.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(ht[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate]));
					issuedUnitsList.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(ht[Common.VbecsTables.IssuedUnit.IssueDateTime]));
					//
					this.lvUnits.Items.Add(issuedUnitsList);
				}
			}
			// No units found in database
			if(this.lvUnits.Items.Count == 0)
			{
				ListViewItem lvItem = new ListViewItem(Common.StrRes.SysErrMsg.Common.NoDataRowsFoundException("").ResString);
				this.lvUnits.Items.Add(lvItem);
				this.lvUnits.CheckBoxes = false;
				lvItem.Tag = null;
			}
			// Set the columns widths
			controls.VbecsFunction.SetColumnWidths(this.lvUnits);
		}

		/// <summary>
		/// Populate patient location at transfusion combo box.
		/// Defaults to the name of the issue to location (if the unit was issued).  
		/// </summary>
		private void PopulateTransfusionLocation()
		{
			ArrayList locations = this._currentPatientTransfusion.GetLocations();
			//
			//clear exisiting list
			this.cmbPatientLocation.Items.Clear();
			//
			//Build the locations list
			if (locations.Count > 0) 
			{
				foreach(string location in locations)
				{
					this.cmbPatientLocation.Items.Add(location);
				}
			}
			//
			this.cmbPatientLocation.SelectedIndex = -1;
		}

		/// <summary>
		/// Gets detail transfusion information for all the selected units
		/// CR 2959
		/// </summary>
		private bool GetPatientTransfusionList()
		{
			int newTransfusionRecordCount = 0;
			//
			int lockedExistingTransfusionRecordCount = 0;
			//
			this._patientTransfusionList.Clear();
			//
			// Called when a new patient transfusion is being loaded.
			this.IsDirty = false;
			//
			System.Collections.ArrayList transfusionGuids = new ArrayList();

			foreach (ListViewItem lvItem in this.lvUnits.CheckedItems)
			{
				bool lockOk = true;
				
				// Creat a temp working Unit to get the BloodUnitGuid info
				Hashtable workingUnit = (Hashtable) lvItem.Tag;

				// Create the new patient transfusion
				_currentPatientTransfusion = new BOL.PatientTransfusion(
					this.patientSelectTool1.SelectedPatient.PatientGuid, 
					(Guid) workingUnit[Common.VbecsTables.IssuedUnit.BloodUnitGuid], 
					false);
				
				// We are obviously using VBECS to enter the transfusion record;
				// the other option would be 'BCE COTS' for records entered via
				// the BCE COTS application
				_currentPatientTransfusion.ApplicationOfRecordId = 
					Common.Utility.GetApplicationOfRecordTypeIntegerValue( Common.ApplicationOfRecordType.VBECS );

				// Attach events
				_currentPatientTransfusion.Invalid += new System.EventHandler(this.OnValid);
				_currentPatientTransfusion.Valid += new System.EventHandler(this.OnValid);
				_currentPatientTransfusion.IsDirtyChanged += new System.EventHandler(this.OnValid);
			
				// Setting the IsDirtyChanged event to fire the SetDirtyFlag function
				// Everytime a property of the variable is altered and thus the form
				// has been changed in one way or another.
				_currentPatientTransfusion.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);

				if(_currentPatientTransfusion.IsNew == true)
				{
					this.ttToolTip.SetToolTip(this.btnUpdate, "");
					_currentPatientTransfusion.SetInitialBrokenRules(this.Name, "default");
	
					// Assing default start and end date
					_currentPatientTransfusion.TransfusionStartDateTime = this._dateIssued; //CR3047: Set transfusion start date/time to issue date/time by default
					_currentPatientTransfusion.TransfusionEndDateTime = this.dtpTransfusionEndDate.Value;
				
					this.rdoCompleted.Checked = true;
					this.rdoCompleted_CheckedChanged(this, EventArgs.Empty);

					// Add my newly created Patient Transfusion object to array list
					this._patientTransfusionList.Add(_currentPatientTransfusion);

					newTransfusionRecordCount += 1;
				}
				else 
				{
					// edit existing record, no rules are broken when page loads
					_currentPatientTransfusion.SetInitialBrokenRules(this.Name, "default", true);

					// Need to lock the patient transfusion guid for editing
					lockOk = this.SetLocks(_currentPatientTransfusion.PatientTransfusionGuid);
					//
					if ( lockOk )
					{
						// Add my newly created Patient Transfusion object to array list
						this._patientTransfusionList.Add(_currentPatientTransfusion);

						lockedExistingTransfusionRecordCount += 1;
					}
				}
				//
				this.OnValid(this, System.EventArgs.Empty);
			}
			//
			return newTransfusionRecordCount + lockedExistingTransfusionRecordCount > 0;
		}

		/// <summary>
		/// Gets a list of all units that are selected by the user and populate the array list
		/// CR 2959
		/// </summary>
		private bool GetSelectedUnitsList()
		{
			int selectedUnitsCount = 0;
			//
			this._selectedUnitsList.Clear();
			//
			System.Collections.ArrayList unitGuids = new ArrayList();
			//
			foreach (ListViewItem lvItem in this.lvUnits.CheckedItems)
			{
				bool lockOk = false;
				//
				Hashtable selectedUnit = (Hashtable)lvItem.Tag;	
				//
				Guid selectedUnitGuid = (Guid)selectedUnit[Common.VbecsTables.IssuedUnit.BloodUnitGuid];
				//
				for ( int idx = 0; idx < this._patientTransfusionList.Count; idx++ )
				{
					PatientTransfusion currentPatientTransfusion = (PatientTransfusion)this._patientTransfusionList[idx];
					//
					if ( currentPatientTransfusion.BloodUnitGuid == selectedUnitGuid )
					{
						// CR 2973 - removed check for currentPatientTransfusion.IsNew  we want to lock all BloodUnit records regardless of PT status 
						// Need to lock blood unit records if new
						lockOk = this.SetLocks( (Guid) selectedUnit[Common.VbecsTables.BloodUnitStatus.BloodUnitStatusGuid] );
						//
						if ( !lockOk )
						{
							// Remove locked Patient Transfusion object from array list
							this._patientTransfusionList.Remove(currentPatientTransfusion);
						}
					}
				}
				//
				if ( lockOk )
				{
					this._selectedUnitsList.Add(selectedUnit);
					//
					selectedUnitsCount += 1;
				}
			}							
			//
			return selectedUnitsCount > 0;
		}

		/// <summary>
		/// Gets a list of all issued and transfused units that are availabel for post-transfusion
		/// </summary>
		private void GetAllUnitsList()
		{
			_allUnits = BOL.PatientTransfusion.GetIssuedAndTransfusedUnitsForPatient(this.patientSelectTool1.SelectedPatient.PatientGuid);
			//By default we don't display transfused units, so filter them 
			this.FilterTransfusedUnits();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2002</CreationDate>
		///
		/// <summary>
		/// Private method to display different panels 
		/// CR 2959
		/// </summary>
		private void ProcessFormPanels()
		{
			// If Patient Select Tool was visible, show Select Units panel next
			if(this.patientSelectTool1.Visible)
			{
				this.pnlUnit.BringToFront();

				this.pnlPatientUnits.Visible = true;
				this.patientDisplayPanel1.Visible = true;
				this.patientSelectTool1.Visible = false;
				this.patientDisplayPanel1.Patient = this.patientSelectTool1.SelectedPatient;
				this.btnOK.EnabledButton = false;
				
				GetAllUnitsList();
				PopulateUnitsListView();
			}
			// If Select Units panel was visible, show transfusion information panel with tabs
			else if(this.pnlPatientUnits.Visible)
			{
				bool continueProcessing = true;
				//
				if( !gov.va.med.vbecs.DAL.VAL.VistALink.EnsureAvailability() )
				{
					this.IsDirty = false;
					this.DialogResult = DialogResult.Cancel;
					this.Close();
					return;
				}
				//
				this.pnlPostTransfusionInfo.BringToFront();
				//
				this.pnlPatientUnits.Visible = false;
				this.pnlPostTransfusionInfo.Visible = true;
				this.pnlPostTransfusionUnit.Visible = true;
				this.patientDisplayPanel2.Visible = true;
				this.patientDisplayPanel2.Patient = this.patientSelectTool1.SelectedPatient;
				this.btnOK.Visible = false;
				
				// Get patient transfusion info for each unit
				if (!GetPatientTransfusionList())
				{
					continueProcessing = false;
				}

				// Get List of all selected units -- If locking fails, false is returned
				if (!GetSelectedUnitsList())
				{
					continueProcessing = false;
				}
				
				if ( continueProcessing )
				{
					// Create a tab for each selected unit 
					CreateTabs();
				
					// Default page view to first tab
					this.tabUnits.SelectedIndex = 0;
				
					// Get unit details for first tab
					_currentUnit = (Hashtable)this._selectedUnitsList[0];

					// Get patient transfusion details for first tab
					_currentPatientTransfusion = (BOL.PatientTransfusion) this._patientTransfusionList[0];

					// Populate the list of patient transfusion locations
					this.PopulateTransfusionLocation();

					// Attached data to the controls
					SetControlData();
				}
				else
				{
					// Need to set the isDirty flag to false to force the window to close
					// if the user had requested a new transfusion record but was locked
					// out
					this.IsDirty = false;

					this.Close();
				}
			}
		}

		/// <summary>
		/// Creates number of tabpages equal to the number of selected units
		/// </summary>
		private void CreateTabs()
		{
			//Need to set _removingTabs, because when you add/remove a tab it fires the Tab_SelectedIndex event, which fails
			this._removingTabs = true;

			//Start at 0 so we can name the zero-indexed tab
			for (int ndx=0; ndx < this._selectedUnitsList.Count; ndx++)
			{
				_currentUnit = (Hashtable) this._selectedUnitsList[ndx];
				if (ndx == 0)
				{
					//Set our zero tab otherwise, it wll have the design-time text 
					this.tabUnits.TabPages[ndx].Text = _currentUnit[Common.VbecsTables.BloodUnit.EyeReadableUnitId] + 
						", " + _currentUnit[Common.VbecsTables.BloodProduct.ProductShortName];
				}
				else
				{
					this.tabUnits.TabPages.Add(new TabPage(_currentUnit[Common.VbecsTables.BloodUnit.EyeReadableUnitId] + 
						", " + _currentUnit[Common.VbecsTables.BloodProduct.ProductShortName]));
				}
			}
			
			this._removingTabs = false;
		}

		/// <summary>
		/// Update the form with/without values from the working _currentpatientTransfusion object
		/// Implements BR_69.08
		/// </summary>
		private void SetControlData()
		{
			this._isUpdatingTransfusedVolume = false;
			//
			//Reset combobox otherwise the system might not set the property correctly when changing tabs.
			this.cmbPatientLocation.SelectedIndex = -1;
			//
			this._isLoading = true;

			// Used to check for delayed transfusion start and prolonged transfusion times
			this._dateIssued = Convert.ToDateTime( this._currentUnit[Common.VbecsTables.IssuedUnit.IssueDateTime] );
			this._remoteStorageIndicator = Convert.ToBoolean( this._currentUnit[Common.VbecsTables.IssuedUnit.RemoteStorageIndicator] );
			this._maximumTransfusionTime = Convert.ToDouble( this._currentUnit[Common.VbecsTables.ComponentClassParameter.MaximumTransfusionTime] );

			// Set Blood Unit and Patient information
			this.txtDateIssued.Text = Common.VBECSDateTime.FormatDateTimeString( this._currentUnit[Common.VbecsTables.IssuedUnit.IssueDateTime].ToString() );
			try
			{
				this.txtIssuedBy.Text = new BOL.VbecsUser(this._currentUnit[Common.VbecsTables.IssuedUnit.IssueTechId].ToString()).UserName;
			}
			catch
			{
				this.txtIssuedBy.Text = _currentUnit[Common.VbecsTables.IssuedUnit.IssueTechId].ToString();
			}
			this.txtUnitID.Text = _currentUnit[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString();
			this.txtProductCode.Text = _currentUnit[Common.VbecsTables.BloodUnit.UnitProductCode].ToString().Trim() +
				_currentUnit[Common.VbecsTables.DonationType.DonationTypeCode].ToString().Trim() +
				_currentUnit[Common.VbecsTables.BloodUnit.UnitDivisionId].ToString().Trim();

	
			this.txtPatientID.Text = this.patientSelectTool1.SelectedPatient.DisplayPatientID;
			this.txtPatientName.Text = BOL.Patient.BuildDisplayName(this.patientSelectTool1.SelectedPatient.FirstName.ToString().Trim(), this.patientSelectTool1.SelectedPatient.MiddleInitial.ToString().Trim(), this.patientSelectTool1.SelectedPatient.LastName.ToString().Trim());

			// Set Bedside Verification date 
			if(this._currentPatientTransfusion.BedsideVerificationDate.Equals(DateTime.MinValue))
			{
				this.txtVerificationDate.Text = string.Empty;
			}
			else
			{
				this.txtVerificationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._currentPatientTransfusion.BedsideVerificationDate.ToString());
			}

			// Set Transfusionist #1
			this.txtTransfusionistID1.Text = this._currentPatientTransfusion.Transfusionist1Id;

			// Set Transfusionist #2
			this.txtTransfusionistID2.Text = this._currentPatientTransfusion.Transfusionist2Id;
			
			// Set Transfusion Start Date - required field
			// CR 2543: remove check for bedside verification date (txtVerificationDate - this field 
			// is not currently used and will never get set).
			if (this._currentPatientTransfusion.TransfusionStartDateTime == DateTime.MinValue)
			{
				this.dtpTransfusionStartDate.Value = this._dateIssued;

				// CR 2602 Value of DateIssued has to be copied to StartDateTime property of PatientTransfusion object
				this._currentPatientTransfusion.TransfusionStartDateTime = this._dateIssued;
			}
			else
			{
				this.dtpTransfusionStartDate.Value = this._currentPatientTransfusion.TransfusionStartDateTime;
			}	

			// Set Transfusion End Date - required field
			this.dtpTransfusionEndDate.Value = this._currentPatientTransfusion.TransfusionEndDateTime;
			
			// BR_69.08: Set Patient Location; if it's null on the patient transfusion record, 
			// then use the issue-to location from ordered unit
			if( this._currentPatientTransfusion.PatientLocation != null
				&& !this._currentPatientTransfusion.PatientLocation.Equals( string.Empty ) )
			{
				this.cmbPatientLocation.Text = this._currentPatientTransfusion.PatientLocation;
			}
			else
			{
				Guid bloodUnitGuid = (Guid)this._currentUnit[Common.VbecsTables.BloodUnit.BloodUnitGuid];
				BOL.IssuedUnit issuedUnit = BOL.IssuedUnit.GetIssuedUnitFromBloodUnitGuid( bloodUnitGuid );
				this.cmbPatientLocation.Text = issuedUnit.IssueToLocationName;
				//
				// save location in case user never changes it (can't be null)
				this._currentPatientTransfusion.PatientLocation = cmbPatientLocation.Text;
			}

			// Set Transfusion Completed Indicator
			if (this._currentPatientTransfusion.TransfusionInterrupted != true)
			{
				this.rdoInterrupted.Checked = false;
				this.rdoCompleted.Checked = true;
				this.rdoCompleted_CheckedChanged(this, EventArgs.Empty);
				this.pnlAmountTransfused.Enabled = false;
				this.rdoHalf.Checked = false;
				this.rdoQuarter.Checked = false;
				this.rdoVolume.Checked = false;
				this.updmL.Enabled = false;
				this.updmL.Value = 0;
			}
			else
			{
				this.rdoCompleted.Checked = false;
				this.rdoInterrupted.Checked = true;
				this.rdoInterrupted_CheckedChanged(this, EventArgs.Empty);
				this.pnlAmountTransfused.Enabled = true;

				// Set Transfused Volume - required field for Interupted transfusion
				if(this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (Decimal) 0.75))
				{
					this.rdoThreeQuarter.Checked = true;
					this.rdoHalf.Checked = false;
					this.rdoQuarter.Checked = false;
					this.rdoVolume.Checked = false;
					this.updmL.Enabled = false;
					this.updmL.Value = 0;
				}
				else if(this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (Decimal) 0.50))
				{
					this.rdoThreeQuarter.Checked = false;
					this.rdoHalf.Checked = true;
					this.rdoQuarter.Checked = false;
					this.rdoVolume.Checked = false;
					this.updmL.Enabled = false;
					this.updmL.Value = 0;
				}
				else if(this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (Decimal) 0.25))
				{
					this.rdoThreeQuarter.Checked = false;
					this.rdoHalf.Checked = false;
					this.rdoQuarter.Checked = true;
					this.rdoVolume.Checked = false;
					this.updmL.Enabled = false;
					this.updmL.Value = 0;
				}
				else
				{
					this.rdoThreeQuarter.Checked = false;
					this.rdoHalf.Checked = false;
					this.rdoQuarter.Checked = false;
					this.rdoVolume.Checked = true;
					this.updmL.Enabled = true;
					try
					{
						this.updmL.Value = this._currentPatientTransfusion.TransfusedVolume;
					}
					catch(FormatException)
					{
						this.updmL.Value = this.updmL.Minimum;
					}
				}
			}
			
			// Set Transfusion Reaction Indicator - required field
			if(this._currentPatientTransfusion.ReactionIndicator == true)
			{
				this.rdoNoReaction.Checked = false;
				this.rdoReactionNoted.Checked = true;
				this.rdoReactionNoted_CheckedChanged(this, EventArgs.Empty);
				this.txtSymptoms.Enabled = true;
			}
			else if(this._currentPatientTransfusion.IsNew == true && this._currentPatientTransfusion.ReactionIndicator == false)
			{
				// no defult value for a new record
				this.rdoNoReaction.Checked = false;
				this.rdoReactionNoted.Checked = false;
				this.txtSymptoms.Enabled = false;
				this.txtSymptoms.Text = String.Empty;				
			}
			else
			{
				this.rdoReactionNoted.Checked = false;
				this.rdoNoReaction.Checked = true;
				this.rdoNoReaction_CheckedChanged(this, EventArgs.Empty);
				this.txtSymptoms.Enabled = false;
			}

			// Set Reaction Symptoms
			if(this._currentPatientTransfusion.ReactionSymptoms != String.Empty)
			{
				this.txtSymptoms.Text = this._currentPatientTransfusion.ReactionSymptoms;
			}
			else
			{
				this.txtSymptoms.Text = String.Empty;
			}

			// Set Comments
			if(this._currentPatientTransfusion.PatientTransfusionComment != String.Empty)
			{
				this.txtComments.Text = this._currentPatientTransfusion.PatientTransfusionComment;
			}
			else
			{
				this.txtComments.Text = String.Empty;
			}

			this._isLoading = false;
		}

		/// <summary>
		/// Does the save of the current tab and then removes the tab from the form
		/// </summary>
		private void SaveCurrentTab()
		{
			int currentTab = this.tabUnits.SelectedIndex;
            
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("Post-Transfusion Information"));
			
			if (saveResult == DialogResult.Yes)
			{
				try
				{
					// Since users can swich radio buttons back and forward, make sure we are only saving what needed.
					// CR 3038: if the transfusion was not interrupted and user did not specify a volume then default to Original Volume
					if(this.rdoCompleted.Checked && this._currentPatientTransfusion.TransfusedVolume == 0)
					{
						this._currentPatientTransfusion.TransfusedVolume = Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume);
					}
					if(this.rdoNoReaction.Checked)
					{
						this._currentPatientTransfusion.ReactionSymptoms = String.Empty;
					}
					// CR 2298, BR_78.06
					if (VistALink.IsAvailable  == false) 
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.DSSConnectionLost());
					}
					if(this._currentPatientTransfusion.Save(this._workloadProcessId))
					{
						// CR 1441
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) this._workloadProcessId);
						if(dt!= null && _workloadProcessId != Common.WorkloadProcessID.Unknown)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}
						this._patientTransfusionList.RemoveAt(currentTab);
						this._selectedUnitsList.RemoveAt(currentTab);
				
						if (this._patientTransfusionList.Count > 0)
						{
							this._removingTabs = true;	
							this.tabUnits.TabPages.RemoveAt(currentTab);
							this._removingTabs = false;
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Post-Transfusion Information"));
					}
				}
				catch(RowVersionException)
				{
					this.btnUpdate.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
		}

		/// <summary> 
		/// Filter transfused units  
		/// </summary>
		private void FilterTransfusedUnits()
		{
			this._issuedUnitsOnly = new System.Collections.ArrayList();

			foreach (Hashtable ht in _allUnits)
			{ 
				if(ht[Common.VbecsTables.BloodUnitStatusCodeCurrent.UnitStatusCode].ToString()[0] != Common.Utility.GetUnitStatusCodeCharFromEnum(Common.UnitStatusCode.Transfused))
				{
					this._issuedUnitsOnly.Add(ht.Clone());
				}
			}
		}

		#endregion

		#region Events/Event Handlers

		/// <summary>
		/// PanelChanges
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void PanelChanges(object sender, System.EventArgs e)
		{
			if (this.patientSelectTool1.Visible)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmEnterPostTransfusionInfo_Patient());
			}
			else if (this.pnlPatientUnits.Visible)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmEnterPostTransfusionInfo_Units());
			}
			else if (this.pnlPostTransfusionInfo.Visible)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC069.FrmEnterPostTransfusionInfo_Info());
			}
		}

		/// <summary>
		/// Form Load
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void FrmEnterPostTransfusionInfo_Load(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/6/2004</CreationDate>
		///
		/// <summary>
		/// Patient deselected event handler, disables the OK button and sets tooltip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>	
		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/6/2004</CreationDate>
		///
		/// <summary>
		/// Patient selected event handler, enables the OK button and sets tooltip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/6/2004</CreationDate>
		/// <summary>
		/// Mouse Hover event handler, displys tooltips
		/// CR 2959
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			// Show tooltip depending what panel is visible. Only available on disabled button
			if (this.btnOK.EnabledButton == false && this.patientSelectTool1.Visible == true)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			}

			if(this.btnOK.EnabledButton == false && this.pnlPatientUnits.Visible == true)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectUnit().ResString);
			}
			else if(this.btnOK.EnabledButton == false && this.pnlPatientUnits.Visible == true)
			{
				this.btnOK.SetToolTip("Units entered by the BCE COTS application are not available for editing.");
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/06/2004</CreationDate>
		///
		/// <summary>
		/// Cancel button click event handler, closes the form
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/06/2004</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, process the request
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.ProcessFormPanels();
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/6/2004</CreationDate>
		///
		///<summary>
		/// Mouse Hover event handler, displys tooltips
		/// CR 2959
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (_isLoading == false)
			{
				ListView lv = (System.Windows.Forms.ListView) sender;
				if (lv.SelectedItems.Count > 0 && 
					(this.lvUnits.CheckBoxes == true))
				{
					ListViewItem lVI = lv.SelectedItems[0];

					Hashtable selectedUnit = (Hashtable) lVI.Tag;

					// Get blood unit object needed to display blood unit detail information 
					BOL.BloodUnit bu = new BOL.BloodUnit( (Guid) selectedUnit[Common.VbecsTables.BloodUnit.BloodUnitGuid] ); 

					this.bloodBagLabel1.BloodUnit = bu;
					this.bloodUnitDetailsTab1.BloodUnit = bu;
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/6/2004</CreationDate>
		///
		private void lvUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (_isLoading == false)
			{
				ListView lv = (ListView) sender;
				ListViewItem lVI = lv.Items[e.Index];
				if ((lv.SelectedItems.Count==0) || (lVI != lv.SelectedItems[0]))
				{
					lVI.Selected = true;
				}
				//
				int ItemsCheckedCount = this.lvUnits.CheckedItems.Count;
			
				if (e.NewValue == CheckState.Checked)
				{
					ItemsCheckedCount = this.lvUnits.CheckedItems.Count + 1;
				}
				else if (e.NewValue == CheckState.Unchecked)
				{
					ItemsCheckedCount = this.lvUnits.CheckedItems.Count - 1;
				}
				
				//Disable or enable the OK button
				if (ItemsCheckedCount == 0)
				{
					this.btnOK.EnabledButton = false;
					this.IsDirty = false;
				}
				else
				{
					this.btnOK.EnabledButton = true;
					this.IsDirty=true;
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion Interrupted radio button check event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rdoInterrupted_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					// Transfusion interrupted radio button checked
					if(this.rdoInterrupted.Checked) 
					{
						this.pnlAmountTransfused.Enabled = true;
						this._currentPatientTransfusion.TransfusionInterrupted = rdoInterrupted.Checked;
						//CR 2602 Setting volume to 0 to trigger broken rules and force user to select volume
						this._currentPatientTransfusion.TransfusedVolume = 0;
						this.errError.SetVbecsError(this.rdoInterrupted, String.Empty); // **** 508 Compliance ***
					}
					else
					{
						this.pnlAmountTransfused.Enabled = false;
					}
					//
					if(this.rdoVolume.Checked)
					{			
						CheckUpdMlValue(sender, e);	
					}
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoReactionNoted, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion Completed radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoCompleted_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading && this._currentPatientTransfusion != null)
				{
					if (this.rdoCompleted.Checked) // Transfusion completed
					{
						this.pnlAmountTransfused.Enabled = false;
						this._currentPatientTransfusion.TransfusionInterrupted = false;
						//CR 2602 setting volume to maximum if transfusion was completed
						this._currentPatientTransfusion.TransfusedVolume = Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume);
						this.errError.SetVbecsError(this.rdoInterrupted, String.Empty); // **** 508 Compliance ***
					}
					else
					{
						this.pnlAmountTransfused.Enabled = false;
					}
					// clear error for updmL since it is not relevant here
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoReactionNoted, err.Message); // **** 508 Compliance ***
			}

		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Reaction Noted radio button check event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rdoReactionNoted_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading && this._currentPatientTransfusion != null)
				{
					if (this.rdoReactionNoted.Checked) // Reaction Noted radio button checked
					{
						this._currentPatientTransfusion.ReactionIndicator = rdoReactionNoted.Checked;
						this.errError.SetVbecsError(this.rdoReactionNoted, string.Empty); // **** 508 Compliance ***
						this.txtSymptoms.Enabled = true;
					}
					else
					{
						this.txtSymptoms.Enabled = false;
					}
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoReactionNoted, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// No Reaction radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoNoReaction_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this.rdoNoReaction.Checked) //  No Reaction radio button checked
					{
						this.txtSymptoms.Enabled = false;
						this._currentPatientTransfusion.ReactionIndicator = false;
						this.errError.SetVbecsError(this.rdoNoReaction, string.Empty); // **** 508 Compliance ***
					}
					else
					{
						this.txtSymptoms.Enabled = true;
					}
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoNoReaction, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// 1/4 Amount Transfused radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoQuarter_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (decimal) 0.25))
						return;
					//
					this._currentPatientTransfusion.TransfusedVolume = Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (decimal) 0.25);
					//
					this.errError.SetVbecsError(this.rdoQuarter, string.Empty); // **** 508 Compliance ***
					//
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoQuarter, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// 1/2 Amount Transfused radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoHalf_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (decimal) 0.50))
						return;
					//
					this._currentPatientTransfusion.TransfusedVolume = Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (decimal) 0.50);
					//
					this.errError.SetVbecsError(this.rdoHalf, string.Empty); // **** 508 Compliance ***
					//
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoHalf, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// 3/4 Amount Transfused radio button is checked or unchecked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void rdoThreeQuarter_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (decimal) 0.75))
						return;
					//
					this._currentPatientTransfusion.TransfusedVolume = Convert.ToInt32(this._currentPatientTransfusion.OriginalVolume * (decimal) 0.75);
					//
					this.errError.SetVbecsError(this.rdoThreeQuarter, string.Empty); // **** 508 Compliance ***
					//
					this.errError.SetVbecsError(this.lblmL, string.Empty); // **** 508 Compliance ***
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.rdoThreeQuarter, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Volume radio button check event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void rdoVolume_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				string warning = string.Empty;
				//
				if (this.rdoVolume.Checked) // Reaction Noted radio button checked
				{
					this.updmL.Enabled = true;
				}
				else
				{
					this.updmL.Enabled = false;
				}
				//
				CheckUpdMlValue(sender, e);
			}
		}

		/// <summary>
		/// Verify values are within acceptable range;
		/// warn if not
		/// Implements BR_69.08
		/// </summary>
		private void CheckUpdMlValue(object sender, System.EventArgs e)
		{
			string warning = string.Empty;
			//
			try
			{
				if(this.updmL.Value < _minTransfusedVolume)
				{
					warning = Common.StrRes.SysErrMsg.UC069.TransfusedVolumeTooLow().ResString;
				}
				else if(this.updmL.Value > this.bloodBagLabel1.BloodUnit.OriginalVolume)
				{
					warning = Common.StrRes.SysErrMsg.UC069.TransfusedVolumeExceeded(this.bloodBagLabel1.BloodUnit.OriginalVolume).ResString;
				}
				//
				this._currentPatientTransfusion.TransfusedVolume = Convert.ToInt32(this.updmL.Value);
			}
			catch(FormatException err)
			{
				warning = err.Message;
			}
			//
			this.errError.SetVbecsError(this.lblmL, warning); // **** 508 Compliance ***
			//
			if (!this._isLoading)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Volume Transfused up/down control value changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updmL_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading && !this._isUpdatingTransfusedVolume)
				{
					if (this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this.updmL.Value))
						return;
					//
					CheckUpdMlValue(sender, e);
				}
			}
			catch(FormatException)
			{
				this._currentPatientTransfusion.TransfusedVolume = int.MinValue;
			}
		}

		/// <summary>
		/// This is to update the NumericUpDown, because if you type a value that is less than the minimum
		/// it won't update the control to the NumericUpDown.Minimum until you click one of the up/down arrows
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void updmL_Leave(object sender, EventArgs e)
		{
			// avoid running updmL_ValueChanged also
			this._isUpdatingTransfusedVolume = true;
			//
			try
			{
				if (this._currentPatientTransfusion.TransfusedVolume == Convert.ToInt32(this.updmL.Value))
				{
					this._isUpdatingTransfusedVolume = false;
					return;
				}
				//
				CheckUpdMlValue(sender, e);
			}
			catch(FormatException err)
			{
				this._currentPatientTransfusion.TransfusedVolume = int.MinValue;
				this.errError.SetVbecsError(this.lblmL, err.Message); // **** 508 Compliance ***
			}
			//
			this._isUpdatingTransfusedVolume = false;
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Symptoms text changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtSymptoms_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.ReactionSymptoms == this.txtSymptoms.Text.Trim())
						return;

					this._currentPatientTransfusion.ReactionSymptoms = this.txtSymptoms.Text.Trim();

					this.errError.SetVbecsError(this.txtSymptoms, string.Empty); // **** 508 Compliance ***
					//
					if (txtSymptoms.Text.Trim().Length > 0)
					{
						this.SetDirtyFlag(sender, e);
					}
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.txtSymptoms, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Comments text changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtComments_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.PatientTransfusionComment == this.txtComments.Text.Trim())
						return;

					this._currentPatientTransfusion.PatientTransfusionComment = this.txtComments.Text.Trim();

					this.errError.SetVbecsError(this.txtComments, string.Empty); // **** 508 Compliance ***
					//
					if (txtComments.Text.Trim().Length > 0)
					{
						this.SetDirtyFlag(sender, e);
					}
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.txtComments, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion Start date changed
		/// Implements BR_69.10
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTransfusionStartDate_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.TransfusionStartDateTime == this.dtpTransfusionStartDate.Value)
					{
						return;
					}
					//
					// Save transfusion start date using VBECSDateTime.DateTimeFormat
					// CR 2500, 2984
					this._currentPatientTransfusion.TransfusionStartDateTime = 
						DateTime.Parse(this.dtpTransfusionStartDate.Value.ToString(Common.VBECSDateTime.DateTimeFormat));
					//
					// BR_69.10 : If {start date > date issued + 30 (minutes)} warn user
					if( !this._remoteStorageIndicator && DateTime.Compare( this.dtpTransfusionStartDate.Value, this._dateIssued.AddMinutes(30) ) > 0 )
					{
						//CR 3002, DR 4046
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC069.DelayedTransfusion());
					}
					//
					// A valid transfusion end date is dependent on the start date, so we check that as well
					this.dtpTransfusionEndDate_ValueChanged(sender, e);
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.dtpTransfusionStartDate, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/13/2004</CreationDate>
		///
		/// <summary>
		/// Transfusion End date changed
		/// Implements BR_69.11
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTransfusionEndDate_ValueChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					// Save transfusion start date using VBECSDateTime.DateTimeFormat
					// CR 2984
					this._currentPatientTransfusion.TransfusionEndDateTime = 
						DateTime.Parse(this.dtpTransfusionEndDate.Value.ToString(Common.VBECSDateTime.DateTimeFormat));
					//
					string warning = string.Empty;
					//
					// BR_69.11 : If {end date > start date + maximum transfusion time (minutes)} warn user
					if( !this._remoteStorageIndicator && this._maximumTransfusionTime > 0 && DateTime.Compare( this.dtpTransfusionEndDate.Value, this.dtpTransfusionStartDate.Value.AddMinutes(this._maximumTransfusionTime) ) > 0 )
					{
						//CR 3002, DR 4046
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC069.ProlongedTransfusion());
					}
					//
					this._currentPatientTransfusion.TransfusionEndDateTime = this.dtpTransfusionEndDate.Value;
					//
					this.SetDirtyFlag(sender, e);
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.dtpTransfusionEndDate, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Event attached to the Valid/Invalid/IsDirtyChanged events of the PatientTransfusion object
		/// Enables the OK button if the record is valid.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnValid(object sender, System.EventArgs e)
		{
			if (this._currentPatientTransfusion.IsValid)
			{
				this.btnUpdate.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				btnUpdate.EnabledButton = true;
			}
			else
			{
				this.btnUpdate.SetToolTip(this._currentPatientTransfusion.GetBrokenRulesMessage(this.Name));
				btnUpdate.EnabledButton = false;
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// PatientLocation SelectedIndex has changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbPatientLocation_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.cmbPatientLocation.SelectedIndex > -1)
				{
					this._currentPatientTransfusion.PatientLocation = cmbPatientLocation.Text;
					//
					this.SetDirtyFlag(sender, e);
				}
				else
				{
					this._currentPatientTransfusion.PatientLocation = string.Empty;
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Transfusionist ID 1 has changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtTransfusionistID1_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.Transfusionist1Id == this.txtTransfusionistID1.Text.Trim())
						return;

					this._currentPatientTransfusion.Transfusionist1Id = this.txtTransfusionistID1.Text.Trim();

					this.errError.SetVbecsError(this.txtTransfusionistID1, string.Empty); // **** 508 Compliance ***
					//
					if (txtTransfusionistID1.Text.Trim().Length > 0)
					{
						this.SetDirtyFlag(sender, e);
					}
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.txtTransfusionistID1, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>05/27/2004</CreationDate>
		///
		/// <summary>
		/// Transfusionist ID 2 has changed
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtTransfusionistID2_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (!this._isLoading)
				{
					if (this._currentPatientTransfusion.Transfusionist2Id == this.txtTransfusionistID2.Text.Trim())
						return;

					this._currentPatientTransfusion.Transfusionist2Id = this.txtTransfusionistID2.Text.Trim();

					this.errError.SetVbecsError(this.txtTransfusionistID2, string.Empty); // **** 508 Compliance ***
					//
					if (txtTransfusionistID2.Text.Trim().Length > 0)
					{
						this.SetDirtyFlag(sender, e);
					}
				}
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.txtTransfusionistID2, err.Message); // **** 508 Compliance ***
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/01/2004</CreationDate>
		///
		/// <summary>
		/// Different tab has been selected
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tabUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!_removingTabs)
			{
				this._currentPatientTransfusion = (BOL.PatientTransfusion) this._patientTransfusionList[this.tabUnits.SelectedIndex];
				this._currentUnit = (Hashtable) this._selectedUnitsList[this.tabUnits.SelectedIndex];
				
				//Populate the list of patient transfusion locations
				this.PopulateTransfusionLocation();
				
				//attached data to the controls
				SetControlData();

				//Fire the event to refresh the OK button's enabled state
				this.OnValid(this, System.EventArgs.Empty);
			}
		}
	
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/04/2004</CreationDate>
		///
		/// <summary>
		///     Click event of Update button, that allows saving tab data. Saves one tab at a time
		/// </summary>
		/// <param name="sender" type="object">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <param name="e" type="System.EventArgs">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <returns>
		///     A void value...
		/// </returns>
		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			SaveCurrentTab();

			if (this._patientTransfusionList.Count == 0)
			{
				this.IsDirty = false;
				this.Close();
			}
			else
			{
				//Setup our remaining tabs
				this._currentPatientTransfusion = (BOL.PatientTransfusion) this._patientTransfusionList[0];
				this._currentUnit = (Hashtable) this._selectedUnitsList[0];
				
				//attached data to the controls
				SetControlData();

				//Fire the event to refresh the OK button's enabled state
				this.OnValid(this, System.EventArgs.Empty);
			}
		}

		/// <summary>
		///     Check Changed event of Show Transfusion units check box.
		/// </summary>
		/// <param name="sender" type="object">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <param name="e" type="System.EventArgs">
		///     <para>
		///         
		///     </para>
		/// </param>
		/// <returns>
		///     A void value...
		/// </returns>
		private void cbShowTransfusedUnits_CheckedChanged(object sender, System.EventArgs e)
		{
			this.PopulateUnitsListView();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmEnterPostTransfusionInfo_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnOK.EnabledButton && this.patientSelectTool1.Visible )
			{
				textToSpeak = Common.StrRes.Tooltips.Common.SelectPatient().ResString;
			}	
			else if ( !this.btnOK.EnabledButton && this.pnlPatientUnits.Visible )
			{
				textToSpeak = Common.StrRes.Tooltips.Common.SelectUnit().ResString;
			}
			else if ( !this.btnUpdate.EnabledButton && this.pnlPostTransfusionInfo.Visible )
			{
				textToSpeak = this._currentPatientTransfusion.GetBrokenRulesMessage(this.Name);
			}
			textToSpeak = string.Concat(textToSpeak, this.bloodUnitDetailsTab1.GetErrorMessages());
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}

			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion 
	}
}

